/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.tinkers_ingenuity.content.tools.stats;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.xiaoyue.tinkers_ingenuity.TinkersIngenuity;
import com.xiaoyue.tinkers_ingenuity.content.library.tools.TIToolStats;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.FloatLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.materials.stats.IRepairableMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatType;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;

public record CurioMainMaterialStats(float movement_speed, float armor, float toughness, float attack, float arrow_damage) implements IRepairableMaterialStats
{
    public static final MaterialStatsId ID = new MaterialStatsId("tinkers_ingenuity", "curio_main");
    public static final MaterialStatType<CurioMainMaterialStats> TYPE = new MaterialStatType(ID, (IMaterialStats)new CurioMainMaterialStats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f), RecordLoadable.create((RecordField)FloatLoadable.ANY.defaultField("movement_speed", (Object)Float.valueOf(0.0f), true, CurioMainMaterialStats::movement_speed), (RecordField)FloatLoadable.ANY.defaultField("armor", (Object)Float.valueOf(0.0f), true, CurioMainMaterialStats::armor), (RecordField)FloatLoadable.ANY.defaultField("toughness", (Object)Float.valueOf(0.0f), true, CurioMainMaterialStats::toughness), (RecordField)FloatLoadable.ANY.defaultField("attack", (Object)Float.valueOf(0.0f), true, CurioMainMaterialStats::attack), (RecordField)FloatLoadable.ANY.defaultField("arrow_damage", (Object)Float.valueOf(0.0f), true, CurioMainMaterialStats::arrow_damage), CurioMainMaterialStats::new));
    private static final String SPEED_BONUS_PREFIX = IMaterialStats.makeTooltipKey((ResourceLocation)TinkersIngenuity.location("movement_speed"));
    private static final String ARMOR_BONUS_PREFIX = IMaterialStats.makeTooltipKey((ResourceLocation)TinkersIngenuity.location("armor"));
    private static final String TOUGHNESS_BONUS_PREFIX = IMaterialStats.makeTooltipKey((ResourceLocation)TinkersIngenuity.location("armor_toughness"));
    private static final String DAMAGE_BONUS_PREFIX = IMaterialStats.makeTooltipKey((ResourceLocation)TinkersIngenuity.location("damage"));
    private static final String ARROW_DAMAGE_BONUS_PREFIX = IMaterialStats.makeTooltipKey((ResourceLocation)TinkersIngenuity.location("arrow_damage"));
    private static final List<Component> DESCRIPTION = ImmutableList.of((Object)IMaterialStats.makeTooltip((ResourceLocation)TinkersIngenuity.location("movement_speed.description")), (Object)IMaterialStats.makeTooltip((ResourceLocation)TinkersIngenuity.location("armor.description")), (Object)IMaterialStats.makeTooltip((ResourceLocation)TinkersIngenuity.location("armor_toughness.description")), (Object)IMaterialStats.makeTooltip((ResourceLocation)TinkersIngenuity.location("attack.description")), (Object)IMaterialStats.makeTooltip((ResourceLocation)TinkersIngenuity.location("arrow_damage.description")));

    public MaterialStatType<?> getType() {
        return TYPE;
    }

    public MaterialStatsId getIdentifier() {
        return ID;
    }

    public List<Component> getLocalizedInfo() {
        ArrayList info = Lists.newArrayList();
        info.add(IToolStat.formatColoredPercentBoost((String)SPEED_BONUS_PREFIX, (float)this.movement_speed));
        info.add(IToolStat.formatColoredPercentBoost((String)ARMOR_BONUS_PREFIX, (float)this.armor));
        info.add(IToolStat.formatColoredPercentBoost((String)TOUGHNESS_BONUS_PREFIX, (float)this.toughness));
        info.add(IToolStat.formatColoredPercentBoost((String)DAMAGE_BONUS_PREFIX, (float)this.attack));
        info.add(IToolStat.formatColoredPercentBoost((String)ARROW_DAMAGE_BONUS_PREFIX, (float)this.arrow_damage));
        return info;
    }

    public List<Component> getLocalizedDescriptions() {
        return DESCRIPTION;
    }

    public void apply(ModifierStatsBuilder builder, float scale) {
        TIToolStats.MOVEMENT_SPEED.update(builder, Float.valueOf(this.movement_speed * scale));
        TIToolStats.ARMOR.update(builder, Float.valueOf(this.armor * scale));
        TIToolStats.ARMOR_TOUGHNESS.update(builder, Float.valueOf(this.toughness * scale));
        TIToolStats.ATTACK_DAMAGE.update(builder, Float.valueOf(this.attack * scale));
        TIToolStats.ARROW_DAMAGE.update(builder, Float.valueOf(this.arrow_damage * scale));
    }

    public int durability() {
        return 0;
    }
}

